#pragma once

namespace MFMeter2 {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Drawing::Printing;	//added manually
	using namespace System::IO;					// likewise
	using namespace System::IO::Ports;			// likewise
	
	/// <summary>
	/// Summary for MyForm
	/// </summary>
	public ref class MyForm3 : public System::Windows::Forms::Form
	{
	public: PrintDocument ^printDocument1 = gcnew PrintDocument();	// added to get form print going
			String^ stringToPrint;
			System::Drawing::Font^ fontToUse;

	private: System::Windows::Forms::Timer^ samplingTimer = gcnew System::Windows::Forms::Timer;


	public:
		MyForm3(void)
		{
			// Silicon Chip 24-bit Arduino based Measuring System App V1.0
			// written by Jim Rowe in MS Visual Studio C++ Prof 2013
			// with significant help from colleague Nicholas Vinen
			// Last revised 12/02/2016 at 4:25 pm

			InitializeComponent();
			findPorts();
			//

		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~MyForm3()
		{
			
			delete components;
	
		}
	private: System::Windows::Forms::MenuStrip^  menuStrip1;
	protected:
	private: System::Windows::Forms::ToolStripMenuItem^  fileToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  openToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  saveToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  exitToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  configureToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  aboutToolStripMenuItem;
	private: System::Windows::Forms::ComboBox^  comboBox1;
	private: System::Windows::Forms::Label^  label1;
	private: System::Windows::Forms::Label^  label2;
	private: System::Windows::Forms::ComboBox^  comboBox2;
	private: System::Windows::Forms::Button^  button1;
	private: System::IO::Ports::SerialPort^  serialPort1;
	private: System::Windows::Forms::TextBox^  textBox1;
	private: System::Windows::Forms::Label^  label3;
	private: System::Windows::Forms::TextBox^  textBox2;
	private: System::ComponentModel::IContainer^  components;

	private:
		/// <summary>
		/// Required designer variables
		volatile Int16 S1bSwPosition;		// used to save switch S1b position
		volatile bool ContSampling = false;	// continuous sampling flag (false = single sample)
		volatile bool SampActive = false;	// sampling active or not flag (true = sampling in progress)
		volatile bool SamplProcessed = false;	// sample processed flag (true = processed)
		static bool exitFlag = false;		// 'OK to take another sample' flag
		volatile Int16 SintBox1 = 0;		// used to save num of samples taken & shown in textBox1
		volatile double SampleValue;		// used to save raw sample received from MFM
		volatile bool SampPresent = false;	// flag to show when a sample has been retrieved
		volatile double dBraw;				// used to store the 'dBraw' value
		volatile double dBVLevel;			// used to store calculated dBV level
		volatile double VoltsRMS;			// used to store the RMS input voltage
		volatile Int32 Impedance;			// used to store the load impedance level
		volatile double dBmLevel;			// used to store the calculated dBm level
		volatile double PwrWatts;			// used to store the calculated power level
		volatile Int16 SampleCount;			// used to save sampling counter
		String^SamString = String::Empty;	// used to save a sample's data string



	private: System::Windows::Forms::ToolStripMenuItem^  singleOrContinuousToolStripMenuItem;
	private: System::Windows::Forms::SaveFileDialog^  saveFileDialog1;
	private: System::Windows::Forms::OpenFileDialog^  openFileDialog1;
	private: System::Windows::Forms::ToolStripMenuItem^  singleSampleToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  ContinSamplingToolStripMenuItem;
	private: System::Windows::Forms::Label^  label4;
	private: System::Windows::Forms::ToolStripMenuItem^  newToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  printToolStripMenuItem;
	private: System::Windows::Forms::PrintDialog^  printDialog1;
	private: System::Windows::Forms::ComboBox^  comboBox3;

		/// </summary>


#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = (gcnew System::ComponentModel::Container());
			this->menuStrip1 = (gcnew System::Windows::Forms::MenuStrip());
			this->fileToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->newToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->openToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->saveToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->printToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->exitToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->configureToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->singleSampleToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->ContinSamplingToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->aboutToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->singleOrContinuousToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->comboBox1 = (gcnew System::Windows::Forms::ComboBox());
			this->label1 = (gcnew System::Windows::Forms::Label());
			this->label2 = (gcnew System::Windows::Forms::Label());
			this->comboBox2 = (gcnew System::Windows::Forms::ComboBox());
			this->button1 = (gcnew System::Windows::Forms::Button());
			this->serialPort1 = (gcnew System::IO::Ports::SerialPort(this->components));
			this->textBox1 = (gcnew System::Windows::Forms::TextBox());
			this->label3 = (gcnew System::Windows::Forms::Label());
			this->textBox2 = (gcnew System::Windows::Forms::TextBox());
			this->saveFileDialog1 = (gcnew System::Windows::Forms::SaveFileDialog());
			this->openFileDialog1 = (gcnew System::Windows::Forms::OpenFileDialog());
			this->label4 = (gcnew System::Windows::Forms::Label());
			this->comboBox3 = (gcnew System::Windows::Forms::ComboBox());
			this->printDialog1 = (gcnew System::Windows::Forms::PrintDialog());
			this->menuStrip1->SuspendLayout();
			this->SuspendLayout();
			// 
			// menuStrip1
			// 
			this->menuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(3) {
				this->fileToolStripMenuItem,
					this->configureToolStripMenuItem, this->aboutToolStripMenuItem
			});
			this->menuStrip1->Location = System::Drawing::Point(0, 0);
			this->menuStrip1->Name = L"menuStrip1";
			this->menuStrip1->Size = System::Drawing::Size(953, 24);
			this->menuStrip1->TabIndex = 0;
			this->menuStrip1->Text = L"menuStrip1";
			// 
			// fileToolStripMenuItem
			// 
			this->fileToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(5) {
				this->newToolStripMenuItem,
					this->openToolStripMenuItem, this->saveToolStripMenuItem, this->printToolStripMenuItem, this->exitToolStripMenuItem
			});
			this->fileToolStripMenuItem->Name = L"fileToolStripMenuItem";
			this->fileToolStripMenuItem->Size = System::Drawing::Size(37, 20);
			this->fileToolStripMenuItem->Text = L"&File";
			// 
			// newToolStripMenuItem
			// 
			this->newToolStripMenuItem->Name = L"newToolStripMenuItem";
			this->newToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->newToolStripMenuItem->Text = L"&New";
			this->newToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::newToolStripMenuItem_Click);
			// 
			// openToolStripMenuItem
			// 
			this->openToolStripMenuItem->Name = L"openToolStripMenuItem";
			this->openToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->openToolStripMenuItem->Text = L"&Open";
			this->openToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::openToolStripMenuItem_Click);
			// 
			// saveToolStripMenuItem
			// 
			this->saveToolStripMenuItem->Name = L"saveToolStripMenuItem";
			this->saveToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->saveToolStripMenuItem->Text = L"&Save";
			this->saveToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::saveToolStripMenuItem_Click);
			// 
			// printToolStripMenuItem
			// 
			this->printToolStripMenuItem->Name = L"printToolStripMenuItem";
			this->printToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->printToolStripMenuItem->Text = L"&Print";
			this->printToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::printToolStripMenuItem_Click);
			// 
			// exitToolStripMenuItem
			// 
			this->exitToolStripMenuItem->Name = L"exitToolStripMenuItem";
			this->exitToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->exitToolStripMenuItem->Text = L"&Exit";
			this->exitToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::exitToolStripMenuItem_Click);
			// 
			// configureToolStripMenuItem
			// 
			this->configureToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(2) {
				this->singleSampleToolStripMenuItem,
					this->ContinSamplingToolStripMenuItem
			});
			this->configureToolStripMenuItem->Name = L"configureToolStripMenuItem";
			this->configureToolStripMenuItem->Size = System::Drawing::Size(72, 20);
			this->configureToolStripMenuItem->Text = L"&Configure";
			// 
			// singleSampleToolStripMenuItem
			// 
			this->singleSampleToolStripMenuItem->Name = L"singleSampleToolStripMenuItem";
			this->singleSampleToolStripMenuItem->Size = System::Drawing::Size(163, 22);
			this->singleSampleToolStripMenuItem->Text = L"&Single Sample";
			this->singleSampleToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::singleSampleToolStripMenuItem_Click);
			// 
			// ContinSamplingToolStripMenuItem
			// 
			this->ContinSamplingToolStripMenuItem->Name = L"ContinSamplingToolStripMenuItem";
			this->ContinSamplingToolStripMenuItem->Size = System::Drawing::Size(163, 22);
			this->ContinSamplingToolStripMenuItem->Text = L"&Contin Sampling";
			this->ContinSamplingToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::ContinSamplingToolStripMenuItem_Click);
			// 
			// aboutToolStripMenuItem
			// 
			this->aboutToolStripMenuItem->Name = L"aboutToolStripMenuItem";
			this->aboutToolStripMenuItem->Size = System::Drawing::Size(52, 20);
			this->aboutToolStripMenuItem->Text = L"&About";
			this->aboutToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::aboutToolStripMenuItem_Click);
			// 
			// singleOrContinuousToolStripMenuItem
			// 
			this->singleOrContinuousToolStripMenuItem->Name = L"singleOrContinuousToolStripMenuItem";
			this->singleOrContinuousToolStripMenuItem->Size = System::Drawing::Size(32, 19);
			// 
			// comboBox1
			// 
			this->comboBox1->FormattingEnabled = true;
			this->comboBox1->Location = System::Drawing::Point(207, 38);
			this->comboBox1->Name = L"comboBox1";
			this->comboBox1->Size = System::Drawing::Size(84, 21);
			this->comboBox1->TabIndex = 1;
			// 
			// label1
			// 
			this->label1->AutoSize = true;
			this->label1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->label1->Location = System::Drawing::Point(12, 39);
			this->label1->Name = L"label1";
			this->label1->Size = System::Drawing::Size(189, 16);
			this->label1->TabIndex = 2;
			this->label1->Text = L"Select serial port for MFM:";
			// 
			// label2
			// 
			this->label2->AutoSize = true;
			this->label2->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->label2->Location = System::Drawing::Point(308, 40);
			this->label2->Name = L"label2";
			this->label2->Size = System::Drawing::Size(133, 16);
			this->label2->TabIndex = 3;
			this->label2->Text = L"Select Baud Rate:";
			// 
			// comboBox2
			// 
			this->comboBox2->FormattingEnabled = true;
			this->comboBox2->Items->AddRange(gcnew cli::array< System::Object^  >(5) { L"9600", L"19200", L"38400", L"57600", L"115200" });
			this->comboBox2->Location = System::Drawing::Point(447, 38);
			this->comboBox2->Name = L"comboBox2";
			this->comboBox2->Size = System::Drawing::Size(119, 21);
			this->comboBox2->TabIndex = 4;
			// 
			// button1
			// 
			this->button1->BackColor = System::Drawing::Color::White;
			this->button1->FlatStyle = System::Windows::Forms::FlatStyle::Flat;
			this->button1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->button1->ForeColor = System::Drawing::Color::Red;
			this->button1->Location = System::Drawing::Point(47, 107);
			this->button1->Name = L"button1";
			this->button1->Size = System::Drawing::Size(301, 49);
			this->button1->TabIndex = 5;
			this->button1->Text = L"Take a Sample / Start Sampling";
			this->button1->UseVisualStyleBackColor = false;
			this->button1->Click += gcnew System::EventHandler(this, &MyForm3::button1_Click);
			// 
			// textBox1
			// 
			this->textBox1->AcceptsReturn = true;
			this->textBox1->BackColor = System::Drawing::Color::White;
			this->textBox1->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->textBox1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->textBox1->ForeColor = System::Drawing::Color::Black;
			this->textBox1->Location = System::Drawing::Point(47, 174);
			this->textBox1->Multiline = true;
			this->textBox1->Name = L"textBox1";
			this->textBox1->ReadOnly = true;
			this->textBox1->ScrollBars = System::Windows::Forms::ScrollBars::Vertical;
			this->textBox1->Size = System::Drawing::Size(853, 349);
			this->textBox1->TabIndex = 6;
			// 
			// label3
			// 
			this->label3->AutoSize = true;
			this->label3->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->label3->Location = System::Drawing::Point(427, 124);
			this->label3->Name = L"label3";
			this->label3->Size = System::Drawing::Size(124, 16);
			this->label3->TabIndex = 7;
			this->label3->Text = L"Range Selected:";
			// 
			// textBox2
			// 
			this->textBox2->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->textBox2->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->textBox2->ForeColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(192)),
				static_cast<System::Int32>(static_cast<System::Byte>(0)));
			this->textBox2->Location = System::Drawing::Point(557, 119);
			this->textBox2->Name = L"textBox2";
			this->textBox2->Size = System::Drawing::Size(343, 26);
			this->textBox2->TabIndex = 8;
			this->textBox2->TextAlign = System::Windows::Forms::HorizontalAlignment::Center;
			// 
			// openFileDialog1
			// 
			this->openFileDialog1->FileName = L"openFileDialog1";
			// 
			// label4
			// 
			this->label4->AutoSize = true;
			this->label4->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->label4->Location = System::Drawing::Point(585, 41);
			this->label4->Name = L"label4";
			this->label4->Size = System::Drawing::Size(227, 16);
			this->label4->TabIndex = 9;
			this->label4->Text = L"Select Load Impedance (ohms):";
			// 
			// comboBox3
			// 
			this->comboBox3->FormattingEnabled = true;
			this->comboBox3->Items->AddRange(gcnew cli::array< System::Object^  >(8) {
				L"600", L"75", L"50", L"32", L"16", L"8", L"4",
					L"2"
			});
			this->comboBox3->Location = System::Drawing::Point(818, 40);
			this->comboBox3->Name = L"comboBox3";
			this->comboBox3->Size = System::Drawing::Size(82, 21);
			this->comboBox3->TabIndex = 10;
			// 
			// printDialog1
			// 
			this->printDialog1->UseEXDialog = true;
			// 
			// MyForm
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->BackColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(224)),
				static_cast<System::Int32>(static_cast<System::Byte>(192)));
			this->ClientSize = System::Drawing::Size(953, 546);
			this->Controls->Add(this->comboBox3);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->textBox2);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->textBox1);
			this->Controls->Add(this->button1);
			this->Controls->Add(this->comboBox2);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->comboBox1);
			this->Controls->Add(this->menuStrip1);
			this->MainMenuStrip = this->menuStrip1;
			this->Name = L"MyForm";
			this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;	// <-- added
			this->Text = L"Silicon Chip MultiFunction Measuring System";
			this->Load += gcnew System::EventHandler(this, &MyForm3::MyForm3_Load);
			this->Click += gcnew System::EventHandler(this, &MyForm3::singleSampleToolStripMenuItem_Click);
			this->menuStrip1->ResumeLayout(false);
			this->menuStrip1->PerformLayout();
			this->ResumeLayout(false);
			this->PerformLayout();


		}
#pragma endregion

	// ------------------------------------------------------------------------------------
	// PROGRAM CODE NOW BEGINS
	// -------------------------------------------------------------------------------------

	// find available serial ports & make visible in comboBox1 list
	private: void findPorts(void)
	{
		// first get the names of available ports
		array<Object^ > ^ objectArray = System::IO::Ports::SerialPort::GetPortNames();
		// then add the string array to the items list for comboBox1
		this->comboBox1->Items->AddRange(objectArray);
	}

	// ---------------------------------------------------------------------------------------
	//	function to perform specialised scaling for AF LvL & Power range (range 1)

	private: void AFLvlScaling(void)
	{
		double DivLogV = 0;
		dBraw = 50.0000 * SampleValue;	// first multiply SampleValue by 50 to get
		// the dBraw level, since in this circuit the output from the AD8307 follows
		// a law of 20mV/dB. So 2.500V becomes equivalent to 125dBraw.

		dBVLevel = dBraw - 89.43697499;	// then get the equivalent dBV level
		// by subtracting (125 - 35.56302501 = 89.43697499), since
		// 125dBraw = 60.00V = +35.56302501dBV (0dBV = 1.000V)

		// next work out the RMS AF input voltage
		DivLogV = dBVLevel / 20.0000;			// first by dividing by 20
		DivLogV = DivLogV * 2.302585093;		// then multiplying by ln(10)
		VoltsRMS = Math::Exp(DivLogV);		// so we can take the antilog (10^DivLogV)
							// (the Exp() function works out the natural exponent e^())

		// then check that the impedance level has been selected by the user
		if (this->comboBox3->Text == String::Empty)
		{
			MessageBox::Show("Please Select Impedance level!", "Impedance Level Not Set", MessageBoxButtons::OK);
			return;
		}
		// if so, get the impedance level that has been selected
		Impedance = Int32::Parse(this->comboBox3->Text);

		// which allows the dBm level to be found
		switch (Impedance)
		{
		case 600:
			dBmLevel = dBraw - 87.2184875;		// conv factor for 600 ohms
			break;		// (125dBraw = 6.0W at 600 ohms = +37.7815125dBm)
		case 75:
			dBmLevel = dBraw - 78.18758763;		// conv factor for 75 ohms
			break;		// (125dBraw = 48W at 75 ohms = +46.81241237dBm)
		case 50:
			dBmLevel = dBraw - 76.42667504;		// conv factor for 50 ohms
			break;		// (125dBraw = 72W at 50 ohms = +48.57332496dBm)
		case 32:
			dBmLevel = dBraw - 74.48847478;		// conv factor for 32 ohms
			break;		// (125dBraw = 112.5W at 32 ohms = +50.51152522dBm)
		case 16:
			dBmLevel = dBraw - 71.47817482;		// conv factor for 16 ohms
			break;		// (125dBraw = 225W at 16 ohms = +53.52182518dBm)
		case 8:
			dBmLevel = dBraw - 68.46787486;		// conv factor for 8 ohms
			break;		// (125dBraw = 450W at 8 ohms = +56.53212514dBm)
		case 4:
			dBmLevel = dBraw - 65.45757491;		// conv factor for 4 ohms
			break;		// (125dBraw = 900W at 4 ohms = +59.542422509dBm)
		case 2:
			dBmLevel = dBraw - 62.44727495;		// conv factor for 2 ohms
		}				// (125dBraw = 1800W at 2 ohms = +62.55272505dBm)

		// then we can work out the power level
		PwrWatts = (VoltsRMS * VoltsRMS) / Impedance;

		// and finally assemble the sample data string
		SamString += dBVLevel.ToString("##.####") + " dBV;  ";
		SamString += VoltsRMS.ToString("##.####") + " Vrms;  " + Environment::NewLine;
		SamString += dBmLevel.ToString("##.####") + " dBm;  ";
		SamString += PwrWatts.ToString("####.####") + " W" + Environment::NewLine;
	}	// end of AF Lvl & Power scaling function

	// --------------------------------------------------------------------------
	// function to perform specialised scaling for RF Lvl & Power range (range 2)

	private: void RFLvlScaling(void)
	{
		double DivLogV = 0;
		dBraw = 40.0000 * SampleValue;	// first multiply SampleValue by 40 to get
		// the dBraw level, since in the RF head end the output from the AD8307
		// follows a law of 25mV/dB. So 0 - 2.500V becomes a range of 0-100dBraw.

		dBVLevel = dBraw - 53.01029996;	// then get the equivalent dBV level by
		// subtracting (100 - 46.98970004 = 53.01029996), since
		// 100dBraw = 223.6067977V = 46.98970004dBV (0dBV = 1.00V) 

		// next work out the RMS RF input voltage
		DivLogV = dBVLevel / 20.0000;		// first by dividing by 20
		DivLogV = DivLogV * 2.302585093;	// then multiplying by ln(10)
		VoltsRMS = Math::Exp(DivLogV);		// so we can take the antilog (10^DivLogV)
							// (the Exp() function works out the natural exponent e^())

		// then check that the impedance level has been selected by the user
		if (this->comboBox3->Text == String::Empty)
		{
			MessageBox::Show("Please Select Impedance level!", "Impedance Level Not Set", MessageBoxButtons::OK);
			return;
		}
		// if so, get the impedance level that has been selected
		Impedance = Int32::Parse(this->comboBox3->Text);

		// which allows us to work out the dBm level
		switch (Impedance)
		{
		case 600:
			dBmLevel = dBraw - 50.79181263;		// conv factor for 600 ohms
			break;		// (100dBraw = 83.333484W at 600 ohms = +49.20819539dBm)
		case 75:
			dBmLevel = dBraw - 41.7609159;		// conv factor for 75 ohms
			break;		// (100dBraw = 666.666W at 75 ohms = +58.23908307dBm)
		case 50:
			dBmLevel = dBraw - 40.00000;		// conv factor for 50 ohms
			break;		// (100dBraw = 1000W at 50 ohms = +60.00000dBm)
		case 32:
			dBmLevel = dBraw - 38.06179974;		// conv factor for 32 ohms
			break;		// (100dBraw = 1562.5W at 32 ohms = +61.93820026dBm)
		case 16:
			dBmLevel = dBraw - 35.05149979;		// conv factor for 16 ohms
			break;		// (100dBraw = 3125W at 16 ohms = +64.94850022dBm)
		case 8:
			dBmLevel = dBraw - 32.04119983;	    // conv factor for 8 ohms
			break;		// (100dBraw = 6250W at 8 ohms = +67.95880017dBm)
		case 4:
			dBmLevel = dBraw - 29.03089987;		// conv factor for 4 ohms
			break;		// (100dBraw = 12,500W at 4 ohms = +70.96910013dBm)
		case 2:
			dBmLevel = dBraw - 26.02059992;		// conv factor for 2 ohms
		}				// (100dBraw = 25,000W at 2 ohms = +73.97940009dBm)

		// then we can work out the power level
		PwrWatts = (VoltsRMS * VoltsRMS) / Impedance;

		// and finally assemble the sample data string
		SamString += dBVLevel.ToString("##.#####") + " dBV;  ";
		SamString += VoltsRMS.ToString("###.####") + " Vrms; " + Environment::NewLine;
		SamString += dBmLevel.ToString("##.#####") + " dBm;  ";
		SamString += PwrWatts.ToString("#####.###") + " W " + Environment::NewLine;
	}	// end of RF Lvl & Power scaling function

	// -------------------------------------------------------------------------
	// 'File>Open' toolstrip menu item click event function

	private: System::Void openToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		Int16 i = 0;	// counter for the for loop
		openFileDialog1->FileName = "MyMFMSampleFile1";
		openFileDialog1->DefaultExt = "mfm";
		openFileDialog1->Filter = "MFM files (*.mfm)|*.mfm|All files (*.*)|*.*";
		DialogResult = openFileDialog1->ShowDialog();	// show the openfile dialog box
		if (DialogResult == System::Windows::Forms::DialogResult::OK)	// check if result = OK
		{
			String^ filename = openFileDialog1->FileName;
			StreamReader^ sr = gcnew StreamReader(filename);	// open the file for reading
			this->comboBox1->Text = sr->ReadLine();		// now get the COM port that was used
			this->comboBox2->Text = sr->ReadLine();		// the baud rate that was used
			this->textBox2->Text = sr->ReadLine();		// get the selected MFM range
			this->comboBox3->Text = sr->ReadLine();		// the selected impedance level
			SintBox1 = Int16::Parse(sr->ReadLine());	// & the number of samples in file
			// then get the sample data
			for (i = 1; i <= SintBox1; i++)
			{
				this->textBox1->Text += sr->ReadLine() + Environment::NewLine;
				this->textBox1->Text += sr->ReadLine() + Environment::NewLine;
				this->textBox1->Text += sr->ReadLine() + Environment::NewLine;
			} 
			sr->Close();	// before closing the stream
		}
	}

	// -------------------------------------------------------------------------
	// 'File>Save' toolstrip menu item click event function

	private: System::Void saveToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		saveFileDialog1->CreatePrompt = true;
		saveFileDialog1->OverwritePrompt = true;
		saveFileDialog1->FileName = "MyMFMSampleFile1";
		saveFileDialog1->DefaultExt = "mfm";
		saveFileDialog1->Filter = "MFM files (*.mfm)|*.mfm|All files (*.*)|*.*";
		DialogResult = saveFileDialog1->ShowDialog();	// show the saveFile dialog box
		if (DialogResult == System::Windows::Forms::DialogResult::OK)
		{
			String^ filename = saveFileDialog1->FileName;
			StreamWriter^ sw = gcnew StreamWriter(filename);	// open the file for writing
			sw->WriteLine(this->comboBox1->Text);	// now save the COM port in current use
			sw->WriteLine(this->comboBox2->Text);	// then save the baud rate in use
			sw->WriteLine(this->textBox2->Text);	// the selected MFM range
			sw->WriteLine(this->comboBox3->Text);	// the selected impedance level
			sw->WriteLine(SintBox1);				// & the number of samples taken
			sw->WriteLine(this->textBox1->Text);	// then save the sample(s)
			sw->Close();							// and finally close the file
		}
	}

	// ----------------------------------------------------------------------------------
	// 'File>Exit' toolstrip menu item click event function
	private: System::Void exitToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		System::Windows::Forms::DialogResult buttonClicked;
		buttonClicked = MessageBox::Show("Sure you want to exit?", "Verify Exit", MessageBoxButtons::YesNo);
		if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
			this->Close();
	}

	// -------------------------------------------------------------------------
	// 'Configure>SingleSample' toolstrip menu item click event function
	private: System::Void singleSampleToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
		{
		System::Windows::Forms::DialogResult buttonClicked;
		buttonClicked = MessageBox::Show("Single Sample only?", "Verify Single Sample", MessageBoxButtons::YesNo);
		if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
			ContSampling = false;
		}

	// --------------------------------------------------------------------------
	// 'Configure>ContinSampling' toolstrip menu item click event function
	private: System::Void ContinSamplingToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
		{
			System::Windows::Forms::DialogResult buttonClicked;
			buttonClicked = MessageBox::Show("Continuous Sampling?", "Verify ContinuousSampling", MessageBoxButtons::YesNo);
			if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
				ContSampling = true;
		}

	// -----------------------------------------------------------------------------------
	// 'About' toolstrip menu item click event function

	private: System::Void aboutToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		String^Message = "Silicon Chip Arduino based Multifunction Meter App V1.0" + "\nWritten by Jim Rowe" + "\nDec 2015 - Feb 2016";
		MessageBox::Show(Message, "Silicon Chip Multifunction Meter", MessageBoxButtons::OK);
	}
	// ------------------------------------------------------------------------------------

private: System::Void MyForm3_Load(System::Object^  sender, System::EventArgs^  e)
{

}
	// -------------------------------------------------------------------------------------
	// function to take action after 500ms timer tick

	static void TimerEventProcessor(System::Object^ sender, System::Timers::ElapsedEventArgs^ e)
	{
		this->samplingTimer->Stop();	// first turn off the timer
		exitFlag = true;		// and raise the exit flag to show time's up
	}

	// ----------------------------------------------------------------------------------------
	// Function to get current position of S1b on MFM shield PCB (saved as S1bSwPosition)
	// & then get a raw sample reading from the MFM & save in SampleValue.

	private: void FetchSample(void)
	{
		SampActive = true;			// raise the SampActive flag
		if (!this->serialPort1->IsOpen)
		{
			this->serialPort1->Open();	// first open the serial port if not already open
		}
		this->serialPort1->WriteLine("r");	// then send cmd char to read switch position
		try {
			S1bSwPosition = Int16::Parse(this->serialPort1->ReadLine());
		} // (now saved in S1bSwPosition, as digit 1|2|3|4|5|6)
		catch (TimeoutException^)
		{
			MessageBox::Show("Port not responding", "Timeout Exception", MessageBoxButtons::OK);
		}

		this->serialPort1->WriteLine("t");	// now send cmd char to get a sample
		try
		{
			SampleValue = Double::Parse(this->serialPort1->ReadLine());	// save in SampleValue
			SampPresent = true;		// and also raise SampPresent flag to show we got one
		}
		catch (TimeoutException^)
		{
			MessageBox::Show("Port not responding", "Timeout Exception", MessageBoxButtons::OK);
		}

	}	// end of FetchSample function

	// -------------------------------------------------------------------------------------
	// function to process sample data after a sample has been received
private: void ProcessSample(void)
{
	if (SampPresent == true)	// if a sample has been retrieved, proceed
	{
		switch (S1bSwPosition)
		{
		case 1:
			this->textBox2->Text = "AF Level & Power";
			AFLvlScaling();
			break;
		case 2:
			this->textBox2->Text = "RF Level & Power";
			RFLvlScaling();
			break;
		case 3:
			this->textBox2->Text = "DC volts (0 - 2.50V)";
			// 2.5V range, so leave this value unchanged
			SamString = SampleValue.ToString("0.#####") + " V; " + Environment::NewLine;
			break;
		case 4:
			this->textBox2->Text = "DC volts (0 - 25.0V)";
			SampleValue = 10.000 * SampleValue;	// 25V range, so multiply by 10
			SamString = SampleValue.ToString("#0.####") + " V; " + Environment::NewLine;
			break;
		case 5:
			this->textBox2->Text = "DC volts (0 - 250.0V)";
			SampleValue = 100.000 * SampleValue;	// 250V range, so multiply by 100
			SamString = SampleValue.ToString("##0.###") + " V; " + Environment::NewLine;
			break;
		case 6:
			this->textBox2->Text = "DC volts (0 - 1000V)";
			SampleValue = 400.000 * SampleValue;	// 1000V range, so multiply by 400
			SamString = SampleValue.ToString("###0.##") + " V; " + Environment::NewLine;
			break;
		default:
			this->textBox2->Text = "Error reading switch";
			break;
		}
		// and display sample value value in textBox1
		SamString = DateTime::Now.ToString() + ": " + Environment::NewLine + SamString + Environment::NewLine;

		this->textBox1->Text += SamString;	// adding the new string to any previous lines
		++SintBox1;		// and incrementing count of samples in textBox1

		SampPresent = false;		// now lower the SampPresent flag since it has been processed
		SamplProcessed = true;		// but raise the sample processed flag
	}
}
	// ----------------------------------------------------------------------------------------------
	// 'Start or Stop Sampling' button click event function
private: System::Void button1_Click(System::Object^  sender, System::EventArgs^  e)
	{
	// first check if sampling is already active, in which case user must want to stop
	if (SampActive == true)
		{
		SampActive = false;		// so lower sampling active flag
		samplingTimer->Stop();	// turn off timer
		this->button1->Text = L"Click to Start Sampling";	// restore button1 text
		this->serialPort1->Close();		// close the serial port
		return;		// and bail out of this event function
		}

	// must be a new start, but now make sure both port & baud rate comboboxes
	// have been setup -- otherwise display reminder and bail out again
	if (this->comboBox1->Text == String::Empty || this->comboBox2->Text == String::Empty)
		{
		MessageBox::Show("Please Select Port & Baud Rate!", "Port Settings Not Made", MessageBoxButtons::OK);
		return;
		}
	else
		{
		// port settings must have been made, so proceed
		try{
			// open serial port if it isn't already open
			if (!this->serialPort1->IsOpen)
				{
				// now set the serial port's PortName property
				this->serialPort1->PortName = this->comboBox1->Text;
				// and its BaudRate property
				this->serialPort1->BaudRate = Int32::Parse(this->comboBox2->Text);
				// and open the serial port
				this->serialPort1->Open();
				}
			}
		catch (UnauthorizedAccessException^)
			{
			MessageBox::Show("Unauthorised Access", "Unauthorised Access", MessageBoxButtons::OK);
			}
		}	// end of port opening sequence

	// Now begin sampling
	this->button1->Text = L"Click to Stop Sampling";	// first changing button1 text
	do
	{
		FetchSample();	// now go get the range switch position and a new sample
		ProcessSample();	// then do the processing & add to textBox1 text
		this->samplingTimer->Tick += gcnew EventHandler(TimerEventProcessor);
		samplingTimer->Interval = 500; // set the timer interval to 500ms
		samplingTimer->Start();	// starts the timer
		while (exitFlag == false)
		{
			// wait until exitFlag becomes true (= OK for another sample)
		}
	} while (ContSampling == true);		// then loop around again if ContSampling flag is true

	SampActive = false;					// otherwise lower SampActive flag
	this->button1->Text = L"Click to Take a Sample";	// and restore button1 text
	}	//  before leaving  the 'Start or Stop Sampling' button click event

	// ----------------------------------------------------------------------------------
	// 'File>New' ToolStrip menu item click event
	private: System::Void newToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		System::Windows::Forms::DialogResult buttonClicked;
		buttonClicked = MessageBox::Show("Sure you want to begin again?", "Verify New Start", MessageBoxButtons::YesNo);
		if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
		{
			ContSampling = false;			// reset to Single sampling
			SintBox1 = 0;				// clear samples count
			this->textBox1->Text = String::Empty;	// wipe text from textBox1
			this->textBox2->Text = String::Empty;	// and also from textBox2
		}
	}

	// ----------------------------------------------------------------------
	// function to allow printing text in textBox1, to one or more pages
private: void printDocument1_PrintPage(Object^sender, PrintPageEventArgs^ e)
	{
		int charactersOnPage = 0;
		int linesPerPage = 0;

		// sets the value of charactersOnPage to the number of characters of
		// stringToPrint that will fit within the bounds of the page
		e->Graphics->MeasureString(this->stringToPrint, this->fontToUse, e->MarginBounds.Size, StringFormat::GenericTypographic, charactersOnPage, linesPerPage);

		// Draws the string within the bounds of the page
		e->Graphics->DrawString(stringToPrint, this->fontToUse, Brushes::Black, e->MarginBounds, StringFormat::GenericTypographic);

		// Remove the portion of the string that has been printed
		this->stringToPrint = this->stringToPrint->Substring(charactersOnPage);

		// finally check to see if more pages are to be printed
		e->HasMorePages = (this->stringToPrint->Length > 0);
	}

	// ----------------------------------------------------------------------
	// 'File>Print' ToolStrip menu item click event
private: System::Void printToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
	{
		System::Drawing::Printing::PrintDocument^ docToPrint = gcnew System::Drawing::Printing::PrintDocument;
		this->stringToPrint = this->textBox1->Text;
		if (!this->fontToUse)
			this->fontToUse = gcnew System::Drawing::Font("Arial", 9.0f, System::Drawing::FontStyle::Regular);
		docToPrint->PrintPage += gcnew PrintPageEventHandler(this, &MyForm3::printDocument1_PrintPage);

		printDialog1->AllowSomePages = false;
		printDialog1->ShowHelp = true;
		printDialog1->AllowSelection = true;
		printDialog1->AllowCurrentPage = true;
		printDialog1->Document = docToPrint;
		//printDialog1->PrinterSettings->DefaultPageSettings->Portrait = true;

		// show the print dialog box & allow user to select, etc.
		System::Windows::Forms::DialogResult result = printDialog1->ShowDialog();

		// if the result from the print dialog box is OK, print the document
		if (result == System::Windows::Forms::DialogResult::OK)
			docToPrint->Print();
	}

};	// end of MyForm3
}
